<?xml version="1.0"?>
<!--
  Copyright 1999-2004 The Apache Software Foundation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:collection="http://apache.org/cocoon/collection/1.0">

<xsl:param name="currentloc"/>
<xsl:param name="backUri"/>
<xsl:param name="upnode"/>


<xsl:template match="/collection:collection">
<injacNavPan>  
  <current>
    <name>
    	<xsl:value-of select="@name"/>
    </name>
  </current>
  <directories parent="{$currentloc}/">
 		<xsl:apply-templates select="collection:collection"/>
  </directories>
  <files parent="{$currentloc}" >
  <xsl:apply-templates select="collection:resource"/>
  </files>
</injacNavPan> 
<injacNavBar>
  	<currentloc>
		<xsl:value-of select="$currentloc" /> 
	</currentloc>
	<upnode>
		<xsl:value-of select="$upnode" /> 
 	</upnode>
	<backUri>
		<xsl:value-of select="$backUri" /> 
	</backUri>
</injacNavBar>

</xsl:template>
   

<xsl:template match="collection:collection">
  <directory>
  	<name>
    		<xsl:value-of select="@name"/>
    	</name>
  	<uri>
    		<xsl:value-of select="@uri"/>
    	</uri> 
  	<lastModified>
    		<xsl:value-of select="@lastModified"/>
    	</lastModified>
	<date>
    		<xsl:value-of select="@date"/>
    	</date>
	<size>
    		<xsl:value-of select="@size"/>
    	</size>
	<sort>
    		<xsl:value-of select="@sort"/>
    	</sort>
	<reverse>
    		<xsl:value-of select="@reverse"/>
    	</reverse>
	<requested>
    		<xsl:value-of select="@requested"/>
    	</requested>
  </directory> 
</xsl:template>
<xsl:template match="collection:resource">
  <xsl:choose>
  	<xsl:when test="contains(@name, '.css')" />
	<xsl:otherwise>	
  		<file>
    			<name>
				<xsl:value-of select="@name"/>
			</name>
			<uri>
    				<xsl:value-of select="@uri"/>
    			</uri> 
	  		<lastModified>
	    			<xsl:value-of select="@lastModified"/>
		    	</lastModified>
			<date>
		    		<xsl:value-of select="@date"/>
		    	</date>
			<size>
	    		<xsl:value-of select="@size"/>
		    	</size>
		</file> 
  	</xsl:otherwise>	
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
